﻿-- Creating table 'PL_Category'
CREATE TABLE [dbo].[PL_Category] (
    [CategoryID] int IDENTITY(1,1) NOT NULL,
    [Name] nvarchar(max)  NOT NULL
);
GO

-- Creating table 'PL_Link'
CREATE TABLE [dbo].[PL_Link] (
    [LinkID] int IDENTITY(1,1) NOT NULL,
    [Name] nvarchar(max)  NOT NULL,
    [Type] tinyint  NOT NULL,
    [Url] nvarchar(max)  NOT NULL,
    [Description] nvarchar(max)  NULL,
    [ImageUrl] nvarchar(max)  NULL,
    [OpenInNewWindow] bit  NOT NULL,
    [CategoryID] int  NULL,
    [PrincipalID] int  NOT NULL
);
GO

-- Creating table 'PL_LinkOrder'
CREATE TABLE [dbo].[PL_LinkOrder] (
    [PrincipalID] int  NOT NULL,
    [ViewID] uniqueidentifier  NOT NULL,
    [Order] nvarchar(max)  NOT NULL
);
GO

-- Creating table 'PL_View'
CREATE TABLE [dbo].[PL_View] (
    [ViewID] uniqueidentifier  NOT NULL,
    [TemplateUrl] nvarchar(max)  NOT NULL,
    [AllowPersonalLinks] bit  NOT NULL,
    [AllowUserDeletePredefLinks] bit  NOT NULL,
    [AllowUserSortPredefLinks] bit  NOT NULL
);
GO

-- Creating table 'PL_ViewLinkDenied'
CREATE TABLE [dbo].[PL_ViewLinkDenied] (
    [ViewID] uniqueidentifier  NOT NULL,
    [LinkID] int  NOT NULL,
    [PrincipalID] int  NOT NULL
);
GO

-- Creating table 'PL_ViewLink'
CREATE TABLE [dbo].[PL_ViewLink] (
    [PL_Link_LinkID] int  NOT NULL,
    [PL_View_ViewID] uniqueidentifier  NOT NULL
);
GO

-- Creating primary key on [CategoryID] in table 'PL_Category'
ALTER TABLE [dbo].[PL_Category]
ADD CONSTRAINT [PK_PL_Category]
    PRIMARY KEY CLUSTERED ([CategoryID] ASC);
GO

-- Creating primary key on [LinkID] in table 'PL_Link'
ALTER TABLE [dbo].[PL_Link]
ADD CONSTRAINT [PK_PL_Link]
    PRIMARY KEY CLUSTERED ([LinkID] ASC);
GO

-- Creating primary key on [PrincipalID], [ViewID] in table 'PL_LinkOrder'
ALTER TABLE [dbo].[PL_LinkOrder]
ADD CONSTRAINT [PK_PL_LinkOrder]
    PRIMARY KEY CLUSTERED ([PrincipalID], [ViewID] ASC);
GO

-- Creating primary key on [ViewID] in table 'PL_View'
ALTER TABLE [dbo].[PL_View]
ADD CONSTRAINT [PK_PL_View]
    PRIMARY KEY CLUSTERED ([ViewID] ASC);
GO

-- Creating primary key on [ViewID], [LinkID], [PrincipalID] in table 'PL_ViewLinkDenied'
ALTER TABLE [dbo].[PL_ViewLinkDenied]
ADD CONSTRAINT [PK_PL_ViewLinkDenied]
    PRIMARY KEY CLUSTERED ([ViewID], [LinkID], [PrincipalID] ASC);
GO

-- Creating primary key on [PL_Link_LinkID], [PL_View_ViewID] in table 'PL_ViewLink'
ALTER TABLE [dbo].[PL_ViewLink]
ADD CONSTRAINT [PK_PL_ViewLink]
    PRIMARY KEY CLUSTERED ([PL_Link_LinkID], [PL_View_ViewID] ASC);
GO

-- Creating foreign key on [PrincipalID] in table 'PL_LinkOrder'
ALTER TABLE [dbo].[PL_LinkOrder]
ADD CONSTRAINT [FK_NB_PrincipalPL_LinkOrder]
    FOREIGN KEY ([PrincipalID])
    REFERENCES [dbo].[NB_Principal]
        ([PrincipalID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating foreign key on [PrincipalID] in table 'PL_ViewLinkDenied'
ALTER TABLE [dbo].[PL_ViewLinkDenied]
ADD CONSTRAINT [FK_NB_PrincipalPL_ViewLinkDenied]
    FOREIGN KEY ([PrincipalID])
    REFERENCES [dbo].[NB_Principal]
        ([PrincipalID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_NB_PrincipalPL_ViewLinkDenied'
CREATE INDEX [IX_FK_NB_PrincipalPL_ViewLinkDenied]
ON [dbo].[PL_ViewLinkDenied]
    ([PrincipalID]);
GO

-- Creating foreign key on [PrincipalID] in table 'PL_Link'
ALTER TABLE [dbo].[PL_Link]
ADD CONSTRAINT [FK_PL_LinkNB_Principal]
    FOREIGN KEY ([PrincipalID])
    REFERENCES [dbo].[NB_Principal]
        ([PrincipalID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_PL_LinkNB_Principal'
CREATE INDEX [IX_FK_PL_LinkNB_Principal]
ON [dbo].[PL_Link]
    ([PrincipalID]);
GO

-- Creating foreign key on [CategoryID] in table 'PL_Link'
ALTER TABLE [dbo].[PL_Link]
ADD CONSTRAINT [FK_PL_LinkCategory]
    FOREIGN KEY ([CategoryID])
    REFERENCES [dbo].[PL_Category]
        ([CategoryID])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_PL_LinkCategory'
CREATE INDEX [IX_FK_PL_LinkCategory]
ON [dbo].[PL_Link]
    ([CategoryID]);
GO

-- Creating foreign key on [LinkID] in table 'PL_ViewLinkDenied'
ALTER TABLE [dbo].[PL_ViewLinkDenied]
ADD CONSTRAINT [FK_PL_LinkPL_ViewLinkDenied]
    FOREIGN KEY ([LinkID])
    REFERENCES [dbo].[PL_Link]
        ([LinkID])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_PL_LinkPL_ViewLinkDenied'
CREATE INDEX [IX_FK_PL_LinkPL_ViewLinkDenied]
ON [dbo].[PL_ViewLinkDenied]
    ([LinkID]);
GO

-- Creating foreign key on [ViewID] in table 'PL_LinkOrder'
ALTER TABLE [dbo].[PL_LinkOrder]
ADD CONSTRAINT [FK_PL_ViewPL_LinkOrder]
    FOREIGN KEY ([ViewID])
    REFERENCES [dbo].[PL_View]
        ([ViewID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_PL_ViewPL_LinkOrder'
CREATE INDEX [IX_FK_PL_ViewPL_LinkOrder]
ON [dbo].[PL_LinkOrder]
    ([ViewID]);
GO

-- Creating foreign key on [ViewID] in table 'PL_ViewLinkDenied'
ALTER TABLE [dbo].[PL_ViewLinkDenied]
ADD CONSTRAINT [FK_PL_ViewPL_ViewLinkDenied]
    FOREIGN KEY ([ViewID])
    REFERENCES [dbo].[PL_View]
        ([ViewID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating foreign key on [PL_Link_LinkID] in table 'PL_ViewLink'
ALTER TABLE [dbo].[PL_ViewLink]
ADD CONSTRAINT [FK_PL_ViewLink_PL_Link]
    FOREIGN KEY ([PL_Link_LinkID])
    REFERENCES [dbo].[PL_Link]
        ([LinkID])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating foreign key on [PL_View_ViewID] in table 'PL_ViewLink'
ALTER TABLE [dbo].[PL_ViewLink]
ADD CONSTRAINT [FK_PL_ViewLink_PL_View]
    FOREIGN KEY ([PL_View_ViewID])
    REFERENCES [dbo].[PL_View]
        ([ViewID])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_PL_ViewLink_PL_View'
CREATE INDEX [IX_FK_PL_ViewLink_PL_View]
ON [dbo].[PL_ViewLink]
    ([PL_View_ViewID]);
GO